<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">	
<xsl:output method="xml"/>
	<xsl:template match="/">
		<html>	
		<head>
		</head>
		<style>
			body 
			{
				background-color: #E5E5E5;
				scrollbar-face-color: #DEE3E7;
				scrollbar-highlight-color: #FFFFFF;
				scrollbar-shadow-color: #DEE3E7;
				scrollbar-3dlight-color: #D1D7DC;
				scrollbar-arrow-color:  #006699;
				scrollbar-track-color: #EFEFEF;
				scrollbar-darkshadow-color: #98AAB1;
				font-family: Verdana, Arial, Helvetica, sans-serif;
				font-size: 8pt;
			}
			
			th	
			{
				border-bottom: 1px #000000 solid;
				border-left: 1px #000000 solid;
				color: #000000; 
				font-weight : bold;
				background-color: #E5E5E5; 
				text-align: center;
			}
			
			h1 {font-size: 20pt; font-weight: bold; text-align: center}
			h2 {font-size: 15pt; font-weight: bold}
			
			table.test { background-color: #FFFFFF; border: 2px #000000 solid; font-size: 8pt; }
			table.description { font-size: 12pt; }
			table.summary { background-color: #FFFFFF; border: 2px #000000 solid; font-size: 8pt; }
			
			td { border-bottom: 1px #000000 solid; border-left: 1px #000000 solid; text-align: center; }
			td.item1 { border: 0px; text-align: left }
			td.item2 { border: 0px; text-align: left }
			td.passed {color: DarkGreen}
			td.failed {color: Crimson; font-weight: bold}
			a.passed {text-align: center; font-size: 10pt; font-weight: bold}
			a.failed {color: Crimson; text-align: center; font-size: 10pt; font-weight: bold;}
			p.pagebreak { page-break-after: always }		
		</style>
		<body>					
		<xsl:apply-templates/>
		</body>		
		</html>
	</xsl:template>

	<xsl:variable name="CommonPageHeader">
		<xsl:if test="/PerformanceResults/@UserType='Factory'">		
			<center>
			<i>for manufacturing records only</i>
			</center>
			<br/>
		</xsl:if>	
	</xsl:variable>
		
	<xsl:variable name="PageHeader">
		<xsl:copy-of select="$CommonPageHeader"/>
		<center>
		<b><xsl:value-of select="/PerformanceResults/@Title"/></b>		
		<br/>
		<i>Instrument S/N: 
		<xsl:value-of select="//Description/Item[@ID='InstrumentSN']/@Value"/>
		</i>
		<hr/>
		</center>
	</xsl:variable>		
	
	<xsl:template match="Description">
		<xsl:copy-of select="$CommonPageHeader"/>
		<h1>
			<xsl:value-of select="/PerformanceResults/@Title"/>
		</h1>		
			
		
		<table cellSpacing="0" class="description">
			<xsl:apply-templates/>
		</table>
		
		<br/><br/>
		
		<center>
		
		<h2>
		Contents
		</h2>		
		
		<table cellSpacing="0" class="summary">
			<tr>
				<th>Test</th>
				<th>Specification</th>
				<xsl:if test="/PerformanceResults/@UserType='Factory'">	
				<th>Factory</th>
				</xsl:if>
			</tr>
			<xsl:for-each select="//Test">					
			<tr>				
				<td><xsl:value-of select="@Title"/></td>
				
				<td>
					<xsl:choose>
						<xsl:when test="@Passed1='yes'">
						PASSED
						</xsl:when>
						
						<xsl:when test="@Passed1='no'">
						FAILED
						</xsl:when>		
						<xsl:otherwise>-</xsl:otherwise>
					</xsl:choose>
				</td>
				
				<xsl:if test="/PerformanceResults/@UserType='Factory'">
				<td>
					<xsl:choose>
						<xsl:when test="@Passed2='yes'">
						PASSED
						</xsl:when>
						
						<xsl:when test="@Passed2='no'">
						FAILED
						</xsl:when>
						<xsl:otherwise>-</xsl:otherwise>
					</xsl:choose>
				</td>
				</xsl:if>				
			</tr>
			</xsl:for-each>			
		</table>		
		</center>
				
		<br/><br/><br/><br/><br/><br/><br/><br/>			

                 <xsl:choose>
                   <xsl:when test="/PerformanceResults/@UserType='Factory'">
                     Approved by:
                     <br/><br/><br/>
                     Date:
                     <br/><br/><br/>
                     Comments:
                   </xsl:when>
                   <xsl:when test="/PerformanceResults/@UserType='Service'">
                     Approved by:
                     <br/><br/><br/>
                     Date:
                     <br/><br/><br/>
                     Comments:
                   </xsl:when>
                   <xsl:when test="/PerformanceResults/@UserType='Customer'">
                     Approved by:
                     <br/><br/><br/>
                     Date:
                     <br/><br/><br/>
                     Comments:
                   </xsl:when>
                 </xsl:choose>

		<xsl:choose>
			<xsl:when test="not(count(//Methods)=0)">
				<p class="pagebreak"/>
			</xsl:when>			
			<xsl:when test="not(count(//Test)=0)">
				<p class="pagebreak"/>
			</xsl:when>
		</xsl:choose>		
	</xsl:template>	
	
	<xsl:template match="Item">
	        <tr class="item">
		<td class="item1"><xsl:value-of select="@Name"/>:</td>
		<td class="item2"><xsl:value-of select="@Value"/></td>
		</tr>	
	</xsl:template>
			
	<xsl:template match="Methods">	
		<xsl:copy-of select="$PageHeader"/>
		<h2>Methods</h2>
		<xsl:apply-templates/>		
		<xsl:if test="not(count(//Test)=0)">
			<p class="pagebreak"/>
		</xsl:if>		
	</xsl:template>		
	
	<xsl:template match="Section">	
		<xsl:copy-of select="$PageHeader"/>
		<xsl:apply-templates/>		
		<xsl:if test="not(position()=last())">
			<p class="pagebreak"/>
		</xsl:if>				
	</xsl:template>
	
	<xsl:template match="Test">					
		<h2>
			<xsl:value-of select="@Title"/>
		</h2>	
		
		<xsl:choose>	
			<xsl:when test="@Passed1='yes'">
			<a class="passed">Especificación: PASA</a>
			</xsl:when>
			
			<xsl:when test="@Passed1='no'">
			<a class="failed">Especificación: FALLA</a>
			</xsl:when>
		</xsl:choose>		
		<br/>		
		<xsl:choose>	
			<xsl:when test="@Passed2='yes'">
			<a class="passed">Fábrica: PASA</a>
			</xsl:when>

			<xsl:when test="@Passed2='no'">
			<a class="failed">Fábrica: FALLA</a>
			</xsl:when>
		</xsl:choose>
		<xsl:apply-templates/>
		(x): indica item falla en especificaciones		
	</xsl:template>		
	
	<xsl:template match="table">			
		<xsl:value-of select="@header"/>
		<table cellSpacing="0" class="test">
			<xsl:apply-templates/>
		</table>					
		<xsl:value-of select="@footer"/>	
		<br/>		
	</xsl:template>

	
	<xsl:template match="tr">
		<tr> 		
			<xsl:apply-templates/>		
		</tr>
	</xsl:template>
	
	<xsl:template match="th">
		<th>
			<xsl:value-of select="."/>
		</th>
	</xsl:template>		
	
	
	<xsl:template match="td">		
		<xsl:choose>
			<xsl:when test="@Passed='no'">
				<td class="failed">
				<xsl:value-of select="."/>x
				</td>
			</xsl:when>
			<xsl:when test="@Passed='yes'">
				<td class="passed">
				<xsl:value-of select="."/>
				</td>
			</xsl:when>		
			<xsl:otherwise>
				<td>
				<xsl:value-of select="."/><br/>
				</td>
			</xsl:otherwise>
		</xsl:choose>				
	</xsl:template>
	
</xsl:stylesheet>
